﻿IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RespondentTraversedQuestions]') AND TYPE in (N'U'))
BEGIN
    CREATE TABLE [RespondentTraversedQuestions](
        [ResRespondent] [int] NOT NULL,
		[QuestionId] [int] NOT NULL,
		[Matrix] [int] NOT NULL,
		CONSTRAINT PK_RespondentTraversedQuestions PRIMARY KEY CLUSTERED (ResRespondent, QuestionId, Matrix),
		CONSTRAINT FK_RespondentTraversedQuestions_Respondent FOREIGN KEY (ResRespondent)
		    REFERENCES [Respondent](ResRespondent)
            ON DELETE CASCADE
	)
END
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VSE_sp_UpdateRespondentTraversedQuestions]') AND schema_Id <> SCHEMA_ID('dbo') AND type in (N'P', N'PC'))
	DROP PROCEDURE [VSE_sp_UpdateRespondentTraversedQuestions]
GO
CREATE PROCEDURE [VSE_sp_UpdateRespondentTraversedQuestions]
	@ResRespondent INT,
	@QuestionIds NVARCHAR(MAX),
    @Matrix INT
AS
    DECLARE @stmt nvarchar(MAX) = '
        INSERT INTO [RespondentTraversedQuestions] 
        SELECT
            @ResRespondent,
            ids,
            @Matrix
        FROM 
        (
            values ' + @QuestionIds + '
        ) as t(ids) 
        WHERE 
            ids NOT IN (
                SELECT 
                    QuestionId 
                FROM 
                    RespondentTraversedQuestions 
                WHERE 
                    ResRespondent = @ResRespondent
                AND
                    Matrix = @Matrix
            )
    '

    EXEC sp_executesql @stmt, N'@ResRespondent INT, @Matrix INT', @ResRespondent, @Matrix
GO